<?php
    /**
    *
    * copyright (c) 2013-2018 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreGalleria extends VisualizzatoreComponente {
        private $javascriptAssociato;
        
        function __construct($db) {
            parent::__construct($db);
            $this->javascriptAssociato = "";
        }

        function generaContenutoSezione($dati) {
            $datiVisualizzatore = parent::getDb()->leggiSingolaRiga("geec_visualizzatoriGallerie",$dati["idElemento"]);
            
            if($datiVisualizzatore["idGalleria"]==0) {
                parent::messaggioDiErrore("Non è stata selezionata alcuna galleria da visualizzare");
            }
            else {
                $datiGalleria       = parent::getDb()->leggiSingolaRiga("geecB_contenuti",$datiVisualizzatore["idGalleria"]);
                
                //creazione elementi portfolio
                $queryImmagini = "SELECT * FROM geec_immagini WHERE idContenuto={$datiGalleria["id"]} AND tipoImmagine LIKE 'immagineGalleria' Order BY posizione ASC";
                $risImmagini = parent::getDb()->eseguiQueryLettura($queryImmagini);

                /*
                 * se non ci sono immagini viene mostrata l'immagine segnaposto
                 */
                if($risImmagini->num_rows==0) {
                    echo"<div class=\"{$datiVisualizzatore["spazioOccupato"]}\">
                        <div class=\"owl-carousel owl-theme galleria-slider\">";
                        echo"<a href=\"immagini/altro/segnaposto.png\"
                                data-toggle=\"lightbox\" 
                                data-gallery=\"nome-della-galleria\" 
                                data-title=\"\" 
                                data-footer=\"\">
                                <div class=\"aspect-ratio-16-9\">
                                    <img src=\"immagini/altro/segnaposto.png\" class=\"img-fluid\">
                                </div>
                             </a>";
                    echo"</div>
                        </div>";
                        $this->javascriptAssociato = "<script src=\"template/js/owl.carousel.min.js\"></script>
                            <script>
                            $('.galleria-slider').owlCarousel({
                                loop:false,
                                margin:0,
                                nav:true,
                                responsive:{
                                    0:{
                                        items:1
                                    },
                                    600:{
                                        items:1
                                    },
                                    1000:{
                                        items:1
                                    }
                                }
                            })
                      </script>";
                }

                if($datiVisualizzatore["tipoVisualizzazione"]=="slider") {
                    echo"<div class=\"{$datiVisualizzatore["spazioOccupato"]}\">
                        <div class=\"owl-carousel owl-theme galleria-slider\">";
                    while($immagine = $risImmagini->fetch_assoc()) {
                        echo"<a href=\"{$immagine["percorso"]}\"
                                data-toggle=\"lightbox\" 
                                data-gallery=\"nome-della-galleria\" 
                                data-title=\"\" 
                                data-footer=\"{$immagine["descrizione"]}\">
                                <div class=\"{$datiVisualizzatore["aspectRatio"]}\">
                                    <img src=\"{$immagine["percorso"]}\" class=\"img-fluid\">
                                </div>
                             </a>";
                    }
                    echo"</div>
                        </div>";
                        $this->javascriptAssociato = "<script src=\"template/js/owl.carousel.min.js\"></script>
                            <script>
                            $('.galleria-slider').owlCarousel({
                                loop:false,
                                margin:0,
                                nav:true,
                                responsive:{
                                    0:{
                                        items:1
                                    },
                                    600:{
                                        items:1
                                    },
                                    1000:{
                                        items:1
                                    }
                                }
                            })
                      </script>";
                }
                else {
                    echo"<div class=container>
                            <div class=\"row galleria\">";
                            while($immagine = $risImmagini->fetch_assoc()) {
                                echo"<div class=\"col-sm-6 col-lg-4 mb-3\">
                                        <a href=\"{$immagine["percorso"]}\"
                                           data-toggle=\"lightbox\" 
                                           data-gallery=\"nome-della-galleria\" 
                                           data-title=\"\" 
                                           data-footer=\"{$immagine["descrizione"]}\">
                                            <div class=\"{$datiVisualizzatore["aspectRatio"]}\">
                                                <img src=\"{$immagine["percorso"]}\" class=\"img-fluid\">
                                            </div>
                                        </a>
                                    </div>";
                            }
                        echo"</div>";
                    echo"</div>";
                }
            }
        }
        
        function getJavascriptAssociato() {
            return $this->javascriptAssociato;
        }
    }
